<?php
// Include database connection
include('db.php');

// Fetch the latest order_id from the orders table
$query = "SELECT MAX(shippingid) AS latest_shipping_id FROM shippingmethod";
$result = mysqli_query($conn, $query);

if ($result) {
    $row = mysqli_fetch_assoc($result);
    $latest_shipping_id = $row['latest_shipping_id'];

    // Increment the latest order_id by 1
    $new_shipping_id = $latest_shipping_id + 1;

    // Return the new order_id in JSON format
    echo json_encode([
        "status" => "success",
        "new_shipping_id" => $new_shipping_id
    ]);
} else {
    // Handle error in case of query failure
    echo json_encode([
        "status" => "error",
        "message" => "Failed to retrieve the latest shipping ID"
    ]);
}

mysqli_close($conn); // Close database connection
?>
